SET ansi_nulls ON
GO

SET quoted_identifier ON
GO

SET ansi_padding ON
GO

IF OBJECT_ID (N'EST_PED_VD_PAG_CARTAO', N'U') IS NULL
BEGIN
	CREATE TABLE [dbo].[EST_PED_VD_PAG_CARTAO](
		[CD_EMP] [int] NOT NULL,
		[CD_FILIAL] [int] NOT NULL,
		[CD_PED] [int] NOT NULL,
		[CD_ORC_PAG] [int] NOT NULL,
		[VLR_PAG] [money] NOT NULL,
		[PARCELA] [int] NOT NULL,
		[NR_CARTAO] [varchar](100) NOT NULL,
		[CD_SEGURANCA] [varchar](10) NOT NULL,
		[VALIDADE] [varchar](10) NOT NULL,
		[NR_AUTORIZACAO] [varchar](20) NULL,
		[CPF] [varchar](14) NULL,
		[CRYPTO_GESTAO] [int] NOT NULL,
	 CONSTRAINT [PK_EST_PED_VD_PAG_CARTAO] PRIMARY KEY CLUSTERED 
	(
		[CD_EMP] ASC,
		[CD_FILIAL] ASC,
		[CD_PED] ASC,
		[CD_ORC_PAG] ASC
	)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
	) ON [PRIMARY]


	SET ANSI_PADDING OFF

	ALTER TABLE [dbo].[EST_PED_VD_PAG_CARTAO] ADD  CONSTRAINT [DF_EST_PED_VD_PAG_CARTAO_PARCELA]  DEFAULT ((1)) FOR [PARCELA]

	ALTER TABLE [dbo].[EST_PED_VD_PAG_CARTAO] ADD  CONSTRAINT [DF_EST_PED_VD_PAG_CARTAO_CRYPTO_GESTAO]  DEFAULT ((0)) FOR [CRYPTO_GESTAO]

	ALTER TABLE [dbo].[EST_PED_VD_PAG_CARTAO]  WITH CHECK ADD  CONSTRAINT [FK_EST_PED_VD_PAG_CARTAO_EST_PED_VD] FOREIGN KEY([CD_EMP], [CD_FILIAL], [CD_PED])
	REFERENCES [dbo].[EST_PED_VD] ([CD_EMP], [CD_FILIAL], [CD_PED])
	ON UPDATE CASCADE
	ON DELETE CASCADE


	ALTER TABLE [dbo].[EST_PED_VD_PAG_CARTAO] CHECK CONSTRAINT [FK_EST_PED_VD_PAG_CARTAO_EST_PED_VD]

END